/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.frequency;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableFrequency;
import mekanism.common.inventory.container.sync.list.SyncableFrequencyList;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.util.WorldUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;

public class TileComponentFrequency
implements ITileComponent {
    private final TileEntityMekanism tile;
    private final Map<FrequencyType<?>, Frequency> heldFrequencies = new LinkedHashMap();
    private final Map<FrequencyType<?>, FrequencyTrackingData> supportedFrequencies = new LinkedHashMap();
    private final Map<FrequencyType<?>, List<? extends Frequency>> publicCache = new LinkedHashMap();
    private final Map<FrequencyType<?>, List<? extends Frequency>> privateCache = new LinkedHashMap();
    private boolean needsSave;
    private boolean needsNotify;

    public TileComponentFrequency(TileEntityMekanism tile) {
        this.tile = tile;
        tile.addComponent(this);
    }

    public boolean hasCustomFrequencies() {
        if (this.supportedFrequencies.containsKey(FrequencyType.SECURITY)) {
            return this.supportedFrequencies.size() > 1;
        }
        return !this.supportedFrequencies.isEmpty();
    }

    public void tickServer() {
        for (Map.Entry<FrequencyType<?>, Frequency> entry : this.heldFrequencies.entrySet()) {
            this.updateFrequency(entry.getKey(), entry.getValue());
        }
        if (this.needsNotify) {
            this.tile.invalidateCachedCapabilities();
            WorldUtils.notifyLoadedNeighborsOfTileChange(this.tile.m_58904_(), this.tile.m_58899_());
            this.needsNotify = false;
        }
        if (this.needsSave) {
            this.tile.m_6596_();
            this.needsSave = false;
        }
    }

    public void track(FrequencyType<?> type, boolean needsSync, boolean needsListCache, boolean notifyNeighbors) {
        this.supportedFrequencies.put(type, new FrequencyTrackingData(needsSync, needsListCache, notifyNeighbors));
    }

    public <FREQ extends Frequency> FREQ getFrequency(FrequencyType<FREQ> type) {
        return (FREQ)this.heldFrequencies.get(type);
    }

    public void setFrequency(FrequencyType<?> type, Frequency freq) {
        this.heldFrequencies.put(type, freq);
    }

    public <FREQ extends Frequency> void unsetFrequency(FrequencyType<FREQ> type) {
        if (this.heldFrequencies.containsKey(type)) {
            this.deactivate(type);
            this.heldFrequencies.remove(type);
            this.setNeedsNotify(type);
        }
    }

    public <FREQ extends Frequency> List<FREQ> getPublicCache(FrequencyType<FREQ> type) {
        return this.getCache(this.publicCache, type);
    }

    public <FREQ extends Frequency> List<FREQ> getPrivateCache(FrequencyType<FREQ> type) {
        return this.getCache(this.privateCache, type);
    }

    private <FREQ extends Frequency> List<FREQ> getCache(Map<FrequencyType<?>, List<? extends Frequency>> cache, FrequencyType<FREQ> type) {
        return cache.computeIfAbsent(type, t -> new ArrayList());
    }

    public <FREQ extends Frequency> void setFrequencyFromData(FrequencyType<FREQ> type, Frequency.FrequencyIdentity data, UUID player) {
        if (player != null) {
            FREQ oldFrequency = this.getFrequency(type);
            FrequencyManager<FREQ> manager = type.getManager(data, player);
            FREQ freq = manager.getOrCreateFrequency(data, player);
            if (oldFrequency == null || !((Frequency)oldFrequency).equals(freq)) {
                manager.deactivate((Frequency)oldFrequency, this.tile);
                ((Frequency)freq).update(this.tile);
                this.setFrequency(type, (Frequency)freq);
                this.setNeedsNotify(type);
            }
        }
    }

    public void removeFrequencyFromData(FrequencyType<?> type, Frequency.FrequencyIdentity data, UUID player) {
        FrequencyManager<?> manager = type.getManager(data, player);
        if (manager != null && manager.remove(data.key(), player)) {
            this.setNeedsNotify(type);
        }
    }

    private <FREQ extends Frequency> void updateFrequency(FrequencyType<FREQ> type, FREQ frequency) {
        FREQ lastFreq = frequency;
        FrequencyManager<FREQ> manager = type.getFrequencyManager(frequency);
        if (manager != null) {
            if (!frequency.isValid()) {
                frequency = manager.validateFrequency(this.tile, frequency);
                this.setNeedsNotify(type);
            }
            if (frequency != null && (frequency = manager.update(this.tile, frequency)) == null) {
                this.setNeedsNotify(type);
            }
        } else {
            frequency = null;
            if (lastFreq != null) {
                this.setNeedsNotify(type);
            }
        }
        if (frequency != lastFreq) {
            this.setFrequency(type, frequency);
        }
    }

    private void setNeedsNotify(FrequencyType<?> type) {
        if (this.supportedFrequencies.get(type).notifyNeighbors) {
            this.needsNotify = true;
        }
        this.needsSave = true;
    }

    private <FREQ extends Frequency> void deactivate(FrequencyType<FREQ> type) {
        FrequencyManager<FREQ> manager;
        FREQ freq = this.getFrequency(type);
        if (freq != null && (manager = type.getFrequencyManager(freq)) != null) {
            manager.deactivate((Frequency)freq, this.tile);
        }
    }

    @Override
    public void read(CompoundTag nbtTags) {
        if (nbtTags.m_128425_("componentFrequency", 10)) {
            CompoundTag frequencyNBT = nbtTags.m_128469_("componentFrequency");
            for (FrequencyType<?> type : this.supportedFrequencies.keySet()) {
                if (!frequencyNBT.m_128425_(type.getName(), 10)) continue;
                Object frequency = type.create(frequencyNBT.m_128469_(type.getName()));
                ((Frequency)frequency).setValid(false);
                this.heldFrequencies.put(type, (Frequency)frequency);
            }
        }
    }

    @Override
    public void write(CompoundTag nbtTags) {
        CompoundTag frequencyNBT = new CompoundTag();
        for (Frequency frequency : this.heldFrequencies.values()) {
            if (frequency == null) continue;
            CompoundTag frequencyTag = new CompoundTag();
            frequency.writeComponentData(frequencyTag);
            frequencyNBT.m_128365_(frequency.getType().getName(), (Tag)frequencyTag);
        }
        nbtTags.m_128365_("componentFrequency", (Tag)frequencyNBT);
    }

    public void readConfiguredFrequencies(Player player, CompoundTag data) {
        if (this.hasCustomFrequencies() && data.m_128425_("componentFrequency", 10)) {
            CompoundTag frequencyNBT = data.m_128469_("componentFrequency");
            for (FrequencyType<?> type : this.supportedFrequencies.keySet()) {
                Frequency.FrequencyIdentity identity;
                CompoundTag frequencyData;
                if (type == FrequencyType.SECURITY) continue;
                if (frequencyNBT.m_128425_(type.getName(), 10) && (frequencyData = frequencyNBT.m_128469_(type.getName())).m_128403_("owner") && (identity = Frequency.FrequencyIdentity.load(type, frequencyData)) != null) {
                    UUID owner = frequencyData.m_128342_("owner");
                    if (!identity.isPublic() && !owner.equals(player.m_142081_())) continue;
                    this.setFrequencyFromData(type, identity, owner);
                    continue;
                }
                this.unsetFrequency(type);
            }
        }
    }

    public void writeConfiguredFrequencies(CompoundTag data) {
        CompoundTag frequencyNBT = new CompoundTag();
        for (Frequency frequency : this.heldFrequencies.values()) {
            if (frequency == null || frequency.getType() == FrequencyType.SECURITY) continue;
            frequencyNBT.m_128365_(frequency.getType().getName(), (Tag)frequency.serializeIdentityWithOwner());
        }
        if (!frequencyNBT.m_128456_()) {
            data.m_128365_("componentFrequency", (Tag)frequencyNBT);
        }
    }

    @Override
    public void invalidate() {
        if (!this.tile.isRemote()) {
            this.heldFrequencies.forEach((key, value) -> this.deactivate((FrequencyType)key));
        }
    }

    @Override
    public void trackForMainContainer(MekanismContainer container) {
        for (Map.Entry<FrequencyType<?>, FrequencyTrackingData> entry : this.supportedFrequencies.entrySet()) {
            if (entry.getValue().needsContainerSync) {
                container.track(SyncableFrequency.create(() -> this.heldFrequencies.get(entry.getKey()), value -> this.heldFrequencies.put((FrequencyType)entry.getKey(), (Frequency)value)));
            }
            if (!entry.getValue().needsListCache) continue;
            this.track(container, entry.getKey());
        }
    }

    private <FREQ extends Frequency> void track(MekanismContainer container, FrequencyType<FREQ> type) {
        if (container.isRemote()) {
            container.track(SyncableFrequencyList.create(() -> this.getPublicCache(type), value -> this.publicCache.put(type, (List<Frequency>)value)));
            container.track(SyncableFrequencyList.create(() -> this.getPrivateCache(type), value -> this.privateCache.put(type, (List<Frequency>)value)));
        } else {
            container.track(SyncableFrequencyList.create(() -> type.getManagerWrapper().getPublicManager().getFrequencies(), value -> this.publicCache.put(type, (List<Frequency>)value)));
            container.track(SyncableFrequencyList.create(() -> type.getManagerWrapper().getPrivateManager(container.getPlayerUUID()).getFrequencies(), value -> this.privateCache.put(type, (List<Frequency>)value)));
        }
    }

    private record FrequencyTrackingData(boolean needsContainerSync, boolean needsListCache, boolean notifyNeighbors) {
    }
}

